'use strict';

angular.module('department_model', ['configuration_model', 'bank_model'])
    .factory('Employee', ['$http', '$q', function($http, $q){
        function Employee(data){
            this.setData(data);
        }

        Employee.prototype = {
            checked: false
            ,fired: false
            ,hired: false
            ,setData: function(data){
                angular.extend(this, data);
            }
            ,getFullName: function(){
                return this.name + ' ' + this.surname;
            }
            ,check: function(){
                this.checked = !this.checked;
            }
            ,isHired: function(){
                return this.hired;
            }
            ,isChecked: function(){
                return this.checked;
            }
            ,isFired: function(){
                return this.fired;
            }
            ,setFired: function(fired){
                this.fired = fired;
            }

        }

        return Employee;
    }])
    .factory('RandomEmployeesList', ['$http', '$q', 'Configuration', 'Employee', function($http, $q, Configuration, Employee){
        var RandomEmployeesList = {
            _isLoadedData: false
            ,_list: []
            ,filterTypes: {}
            ,loadData: function(callbackSuccess, callbackError){
                if(this._isLoadedData){
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlRandomEmployees)
                    .success(function(data){
                        scope.setData(data);
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(data);
                        }
                    })
                    .error(function(data){
                        defer.reject();
                        if(typeof callbackError != 'undefined')
                        {
                            callbackError(data);
                        }
                    })
                ;

                return defer.promise;
            }
            ,setData: function(data){
                var scope = this;

                scope._list = [];
                data.forEach(function(employeeData){
                    scope._list.push(new Employee(employeeData));
                });
                scope.setFilterTypes(['education','studies']);
            }
            ,setFilterTypes: function(nameList){
                var scope = this;

                scope.filterTypes = {};
                scope._list.forEach(function(employee){
                    nameList.forEach(function(name){
                        if(scope.filterTypes[name] == undefined){
                            scope.filterTypes[name] = [];
                        }
                        if(scope.filterTypes[name].indexOf(employee[name]) === -1 && employee[name] !== ''){
                            scope.filterTypes[name].push(employee[name]);
                        }
                    });

                });
            }
            ,checkAll: function(check){
                this._list.forEach(function(employee){
                    employee.checked = check;
                });
            }
            ,reload: function(callbackSuccess, callbackError){
                this._isLoadedData = false;
                return this.loadData(callbackSuccess, callbackError);
            }
        }

        return RandomEmployeesList;
    }])
    .factory('Department', ['$http', 'Employee', 'Configuration', function($http, Employee, Configuration){
        function Department(data){
            data._employeesIds = []; // reset dany bo dziwne rzeczy sie dzialy
            this.setData(data);
        }

        Department.prototype = {
            employees: []
            ,_employeesIds: []
            ,dismiss: []
            ,_originalEmployees: []
            ,setData: function(data){
                angular.extend(this, data);

                this.employees.forEach(function(employeeData, key){
                    this.employees[key] = new Employee(employeeData);
                    this._employeesIds.push(employeeData.id);
                }, this);
                this._originalEmployees = angular.copy(this.employees);
            }
            ,getCostEmployees: function(){
                var cost = 0;
                this.employees.forEach(function(Employee){
                    if(!Employee.isFired())
                    {
                        cost += Employee.salary;
                    }
                }, this);

                return cost;
            }
            ,getNumberOfEmployees: function(){
                return this._employeesIds.length;
            }
            ,hireEmployee: function(Employee){
                var NewEmployee = angular.copy(Employee);
                NewEmployee.checked = false;
                NewEmployee.fired = false;
                NewEmployee.hired = true;

                this.employees.push(NewEmployee);
                this._employeesIds.push(NewEmployee.id);
            }
            ,rehireEmployee: function(Employee){
                Employee.checked = false;
                Employee.fired = false;
                Employee.hired = false;
                this._employeesIds.push(Employee.id);
            }
            ,isChanged: function(){
                return !angular.equals(this.employees, this._originalEmployees);
            }
            ,isHiredEmployee: function(Employee){
                return (this._employeesIds.indexOf(Employee.id) > -1);
            }
            ,fireEmployee: function(Employee){
                if(Employee.isHired())
                {
                    var index = this.employees.indexOf(Employee);
                    if(index !== -1)
                    {
                        this.employees.splice(index,1);
                    }
                }
                else
                {
                    Employee.setFired(true);
                }

                var idIndex = this._employeesIds.indexOf(Employee.id);
                this._employeesIds.splice(idIndex, 1);
            }
            ,saveChanges: function(callbackSuccess, callbackError){
                var scope = this;
                $http.post(Configuration.urlEmployees, {
                        departmentId: scope.id
                        ,roundId: roundId
                        ,employees: this.employees
                    })
                    .success(function(data){
                        scope.employees = [];
                        scope._employeesIds = [];
                        data.forEach(function(employeeData){
                            scope.employees.push(new Employee(employeeData));
                            scope._employeesIds.push(employeeData.id);
                        });
                        scope._originalEmployees = angular.copy(scope.employees);

                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(data);
                        }
                    })
                    .error(function(data){
                        if(typeof callbackError != 'undefined')
                        {
                            callbackError(data);
                        }
                    })
                ;
            }
        }

        return Department;
    }])
    .factory('DepartmentsList', ['$http', '$q', 'Configuration', 'Department', function($http, $q, Configuration, Department){
        var DepartmentsList = {
            _isLoadedData: false
            ,_list: []
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlDepartments)
                    .success(function(data){
                        scope._list = [];
                        data.forEach(function(departmentData){
                            var data = departmentData.department;
                            data.employees = departmentData.employees;
                            var Dep = new Department(data);
                            scope._list.push(Dep);
                        });
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                    })
                    .error(function(data){
                        defer.reject();
                    })
                ;

                return defer.promise;
            }
            ,isCompanyEmployee: function(Employee){
                var isHired = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    isHired = this._list[i].isHiredEmployee(Employee);
                    if(isHired)
                    {
                        break;
                    }
                }
                return isHired;
            }

        };

        return DepartmentsList;
    }])
;